// MainFrm.cpp : CMainFrame Class source code
//

#include "stdafx.h"
#include "defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	ON_COMMAND_EX(CG_ID_VIEW_GPLIST, OnBarCheck)
	ON_UPDATE_COMMAND_UI(CG_ID_VIEW_GPLIST, OnUpdateControlBarMenu)
	ON_COMMAND_EX(CG_ID_VIEW_DISPLAYCOLOR, OnBarCheck)
	ON_UPDATE_COMMAND_UI(CG_ID_VIEW_DISPLAYCOLOR, OnUpdateControlBarMenu)
	ON_COMMAND_EX(CG_ID_VIEW_BACKCOLOR, OnBarCheck)
	ON_UPDATE_COMMAND_UI(CG_ID_VIEW_BACKCOLOR, OnUpdateControlBarMenu)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_1To1, On1To1)
	ON_COMMAND(ID_1ToN, On1ToN)
	ON_COMMAND(ID_BackColor0, OnBackColor0)
	ON_COMMAND(ID_BackColor1, OnBackColor1)
	ON_COMMAND(ID_BackColor2, OnBackColor2)
	ON_COMMAND(ID_BackColor3, OnBackColor3)
	ON_COMMAND(ID_BackColor4, OnBackColor4)
	ON_COMMAND(ID_BackColor5, OnBackColor5)
	ON_COMMAND(ID_BackColor6, OnBackColor6)
	ON_COMMAND(ID_BackColor7, OnBackColor7)
	ON_COMMAND(ID_BackColorBlink, OnBackColorBlink)
	ON_COMMAND(ID_BackColorBlink_F, OnBackColorBlink_F)
	ON_COMMAND(ID_BackColorBlink_S, OnBackColorBlink_S)
	ON_COMMAND(ID_DisplayColor0, OnDisplayColor0)
	ON_COMMAND(ID_DisplayColor1, OnDisplayColor1)
	ON_COMMAND(ID_DisplayColor2, OnDisplayColor2)
	ON_COMMAND(ID_DisplayColor3, OnDisplayColor3)
	ON_COMMAND(ID_DisplayColor4, OnDisplayColor4)
	ON_COMMAND(ID_DisplayColor5, OnDisplayColor5)
	ON_COMMAND(ID_DisplayColor6, OnDisplayColor6)
	ON_COMMAND(ID_DisplayColor7, OnDisplayColor7)
	ON_COMMAND(ID_DisplayColorBlink, OnDisplayColorBlink)
	ON_COMMAND(ID_DisplayColorBlink_F, OnDisplayColorBlink_F)
	ON_COMMAND(ID_DisplayColorBlink_S, OnDisplayColorBlink_S)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,
	ID_INDICATOR_KANA,
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
	ID_INDICATOR_ORG,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame Construction / extinction of the class

CMainFrame::CMainFrame()
{
}


CMainFrame::~CMainFrame()
{
}


int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// ToolBar
	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // Failed to create
	}
	//	Not support paint on GP-Pro EX
	m_wndToolBar.GetToolBarCtrl().DeleteButton(m_wndToolBar.GetToolBarCtrl().CommandToIndex(ID_GpPenEscP));

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // failed
	}

	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	{
		//	Init dialog bar m_wndGpList
		if (!m_wndGpList.Create(this, CG_IDD_GPLIST,
			CBRS_LEFT | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_HIDE_INPLACE,
			CG_ID_VIEW_GPLIST))
		{
			TRACE0("Faild to create DialogBar m_wndGpList\n");
			return -1;		// failed
		}

		m_wndGpList.EnableDocking(CBRS_ALIGN_LEFT | CBRS_ALIGN_RIGHT);  
		EnableDocking(CBRS_ALIGN_ANY);
		DockControlBar(&m_wndGpList);
	}

	// Display Color Bar
	if (!m_wndDisplayColorToolBar.Create(
		this,WS_CHILD | WS_VISIBLE | CBRS_TOP  | CBRS_TOOLTIPS | CBRS_FLYBY ,CG_ID_VIEW_DISPLAYCOLOR)||
		!m_wndDisplayColorToolBar.LoadToolBar(IDR_DISPLAYCOLOR))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // Failed
	}
	m_wndDisplayColorToolBar.SetBarStyle(m_wndDisplayColorToolBar.GetBarStyle() | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
	m_wndDisplayColorToolBar.EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndDisplayColorToolBar);
	
	// Background color bar
	if (!m_wndBackColorToolBar.Create(this,WS_CHILD | WS_VISIBLE | CBRS_TOP  | CBRS_TOOLTIPS | CBRS_FLYBY , CG_ID_VIEW_BACKCOLOR) || 
		!m_wndBackColorToolBar.LoadToolBar(IDR_BACKCOLOR))	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // Failed
	}
	m_wndBackColorToolBar.SetBarStyle(m_wndBackColorToolBar.GetBarStyle() |	CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
	m_wndBackColorToolBar.EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndBackColorToolBar);


	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	return CMDIFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnose a class

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame Message Handler


void CMainFrame::On1To1() 
{
	theApp.m_TargetGP_1ToN = FALSE ;
	ButtonDraw();
}

void CMainFrame::On1ToN() 
{
	theApp.m_TargetGP_1ToN = TRUE ;
	ButtonDraw();
}


void CMainFrame::ButtonDraw()
{
	int i ;

	//	Change state the icon for display color
	m_wndDisplayColorToolBar.GetToolBarCtrl().PressButton(ID_DisplayColorBlink,((theApp.m_cDisplayColor & B_BLINK) == B_BLINK_M)) ;
	m_wndDisplayColorToolBar.GetToolBarCtrl().PressButton(ID_DisplayColorBlink_F,((theApp.m_cDisplayColor & B_BLINK) == B_BLINK_F)) ;
	m_wndDisplayColorToolBar.GetToolBarCtrl().PressButton(ID_DisplayColorBlink_S,((theApp.m_cDisplayColor & B_BLINK) == B_BLINK_S)) ;
	for( i = 0 ; i < 8 ; i++){
		m_wndDisplayColorToolBar.GetToolBarCtrl().PressButton(ID_DisplayColor0+i,((theApp.m_cDisplayColor & ~B_BLINK) == i)) ;
	}

	//	Change state the icon for background color
	m_wndBackColorToolBar.GetToolBarCtrl().PressButton(ID_BackColorBlink,((theApp.m_cBackColor & B_BLINK) == B_BLINK_M)) ;
	m_wndBackColorToolBar.GetToolBarCtrl().PressButton(ID_BackColorBlink_F,((theApp.m_cBackColor & B_BLINK) == B_BLINK_F)) ;
	m_wndBackColorToolBar.GetToolBarCtrl().PressButton(ID_BackColorBlink_S,((theApp.m_cBackColor & B_BLINK) == B_BLINK_S)) ;
	for( i = 0 ; i < 8 ; i++){
		m_wndBackColorToolBar.GetToolBarCtrl().PressButton(ID_BackColor0+i,((theApp.m_cBackColor & ~B_BLINK) == i)) ;
	}

	//	Change state the icon for draw
	for( i = 0 ; i < GpPen_MAX ; i++){
		m_wndToolBar.GetToolBarCtrl().PressButton( theApp.m_dwGpPen_ID[i],(theApp.m_pCurrentGpPen == theApp.m_pGpPens[i])) ;
	}

	//	Change state the icon for GP
	m_wndToolBar.GetToolBarCtrl().PressButton( ID_1To1,!theApp.m_TargetGP_1ToN); 
	m_wndToolBar.GetToolBarCtrl().PressButton( ID_1ToN,theApp.m_TargetGP_1ToN); 
}

#define GpColorSet(a,b) a = (a & B_BLINK)|b 
#define GpBlinkSet(a,b)	if((a&B_BLINK)==b){a&=~B_BLINK;}else{a=((a&~B_BLINK)|b);}
void CMainFrame::OnBackColor0() 
{
	GpColorSet(theApp.m_cBackColor,0) ; ButtonDraw() ;
}

void CMainFrame::OnBackColor1() 
{
	GpColorSet(theApp.m_cBackColor,1) ; ButtonDraw() ;
}

void CMainFrame::OnBackColor2() 
{
	GpColorSet(theApp.m_cBackColor,2) ; ButtonDraw() ;
}

void CMainFrame::OnBackColor3() 
{
	GpColorSet(theApp.m_cBackColor,3) ; ButtonDraw() ;
}

void CMainFrame::OnBackColor4() 
{
	GpColorSet(theApp.m_cBackColor,4) ; ButtonDraw() ;
}

void CMainFrame::OnBackColor5() 
{
	GpColorSet(theApp.m_cBackColor,5) ; ButtonDraw() ;
}

void CMainFrame::OnBackColor6() 
{
	GpColorSet(theApp.m_cBackColor,6) ; ButtonDraw() ;
}

void CMainFrame::OnBackColor7() 
{
	GpColorSet(theApp.m_cBackColor,7) ; ButtonDraw() ;
}

void CMainFrame::OnBackColorBlink() 
{
	GpBlinkSet(theApp.m_cBackColor,B_BLINK_M) ; ButtonDraw() ;
}

void CMainFrame::OnBackColorBlink_F() 
{
	GpBlinkSet(theApp.m_cBackColor,B_BLINK_F) ; ButtonDraw() ;
}

void CMainFrame::OnBackColorBlink_S() 
{
	GpBlinkSet(theApp.m_cBackColor,B_BLINK_S) ; ButtonDraw() ;
}


void CMainFrame::OnDisplayColor0() 
{
	GpColorSet(theApp.m_cDisplayColor,0) ; ButtonDraw() ;
}

void CMainFrame::OnDisplayColor1() 
{
	GpColorSet(theApp.m_cDisplayColor,1) ; ButtonDraw() ;
}

void CMainFrame::OnDisplayColor2() 
{
	GpColorSet(theApp.m_cDisplayColor,2) ; ButtonDraw() ;
}

void CMainFrame::OnDisplayColor3() 
{
	GpColorSet(theApp.m_cDisplayColor,3) ; ButtonDraw() ;
}

void CMainFrame::OnDisplayColor4() 
{
	GpColorSet(theApp.m_cDisplayColor,4) ; ButtonDraw() ;
}

void CMainFrame::OnDisplayColor5() 
{
	GpColorSet(theApp.m_cDisplayColor,5) ; ButtonDraw() ;
}

void CMainFrame::OnDisplayColor6() 
{
	GpColorSet(theApp.m_cDisplayColor,6) ; ButtonDraw() ;
}

void CMainFrame::OnDisplayColor7() 
{
	GpColorSet(theApp.m_cDisplayColor,7) ; ButtonDraw() ;
}

void CMainFrame::OnDisplayColorBlink() 
{
	GpBlinkSet(theApp.m_cDisplayColor,B_BLINK_M) ; ButtonDraw() ;
}

void CMainFrame::OnDisplayColorBlink_F() 
{
	GpBlinkSet(theApp.m_cDisplayColor,B_BLINK_F) ; ButtonDraw() ;
}

void CMainFrame::OnDisplayColorBlink_S() 
{
	GpBlinkSet(theApp.m_cDisplayColor,B_BLINK_S) ; ButtonDraw() ;
}
	
//IWĩCWP[^ɕ\
void CMainFrame::PutStatusBarOrg(LPCTSTR str)
{
	int n=m_wndStatusBar.CommandToIndex(ID_INDICATOR_ORG);
	if(n>=0){
		m_wndStatusBar.SetPaneText(n,str);
	}

}

